/*
 * TraceWindowManager.h
 *
 *  Created on: 29.06.2010
 *      Author: stefan.detter
 */

#ifndef TRACEWINDOWMANAGER_H_
#define TRACEWINDOWMANAGER_H_

#include <QObject>

class QDockWidget;
class QTableView;
class QPushButton;
class QrfeTraceModel;

class TraceWindowManager : public QObject
{
	Q_OBJECT

public:
	TraceWindowManager(QDockWidget* traceDockWidget, QTableView* traceTableView, QPushButton* clearButton, QPushButton* exportButton, QObject* parent = 0);
	virtual ~TraceWindowManager();

	void showTraceWindow(bool show);

public slots:
    void clear();

private:
	QDockWidget* 	m_traceDockWidget;
	QTableView* 	m_traceTableView;
	QPushButton* 	m_clearButton;
	QPushButton* 	m_exportButton;
	QrfeTraceModel* m_traceModel;
};

#endif /* TRACEWINDOWMANAGER_H_ */
